// import { Button } from "@/components/ui/button";
// import { useModal } from "@/context/ModalProvider";
// import {
//   ChevronDown,
//   ChevronRight,
//   Edit,
//   Plus,
//   Trash2,
//   Eye,
// } from "lucide-react";
// import {
//   Dialog,
//   DialogContent,
//   DialogHeader,
//   DialogTitle,
//   DialogFooter,
// } from "@/components/ui/dialog";
// import { useState } from "react";
// import { useMutation, useQueryClient } from "@tanstack/react-query";

// import { DialogDescription } from "@radix-ui/react-dialog";
// import Image from "next/image";

// export function TreeItem({
//   tags,
//   node,
//   isExpanded,
//   onToggle,
//   onAdd,
//   onEdit,
//   onView,
//   onDelete,
//   showCount = false,
// }) {

//   const [viewDialog, setViewDialog] = useState(false);
//   const [deleteDialog, setDeleteDialog] = useState(false);
//   const queryClient = useQueryClient();

//   const deleteMutation = useMutation({
//     mutationFn: onDelete,
//     onSuccess: () => {
//       queryClient.invalidateQueries([tags]);
//       setDeleteDialog(false);
//     },
//   });

//   const handleDelete = () => {
//     deleteMutation.mutate(node.id);
//   };

//   return (
//     <>
//       <div
//         className="flex items-center justify-between px-4 py-2 hover:bg-gray-100 cursor-pointer"
//         onClick={(e) => {
//           e.stopPropagation();
//           onToggle();
//         }}
//       >
//         <div className="flex items-center">
//           <Button variant="ghost" size="icon" className="w-8 h-8">
//             {isExpanded ? (
//               <ChevronDown className="w-4 h-4 text-gray-500" />
//             ) : (
//               <ChevronRight className="w-4 h-4 text-gray-500" />
//             )}
//           </Button>

//           {!node?.category_image ? (
//             <div className="w-6 h-6 rounded-full bg-brand-dark text-brand-gold flex items-center justify-center text-sm font-bold mr-2">
//               {node?.name.slice(0, 1)}
//             </div>
//           ) : (
//             <Image
//               src={node.category_image}
//               alt={node.name}
//               width={32}
//               height={32}
//               className="rounded-full object-cover mr-2"
//             />
//           )}

//           <span className="text-sm mr-2">{node.name}</span>
//           {showCount && node?.children?.length > 0 && (
//             <p className="text-brand-dark text-[9px] bg-gray-100 rounded-full px-1">
//               {node?.children?.length}
//             </p>
//           )}
//         </div>

//         <div className="flex items-center space-x-2">
//           {onView && (
//             <Button
//               variant="ghost"
//               size="icon"
//               className="w-8 h-8"
//               onClick={(e) => {
//                 e.stopPropagation();
//                 setViewDialog(true);
//               }}
//             >
//               <Eye className="w-4 h-4 text-blue-500" />
//             </Button>
//           )}
//           <Button
//             variant="ghost"
//             size="icon"
//             className="w-8 h-8"
//             onClick={(e) => {
//               e.stopPropagation();
//               onAdd?.(node.id);
//             }}
//           >
//             <Plus className="w-4 h-4" />
//           </Button>
//           {onEdit && (
//             <Button
//               variant="ghost"
//               size="icon"
//               className="w-8 h-8"
//               onClick={(e) => {
//                 e.stopPropagation();
//                 onEdit?.(node);
//               }}
//             >
//               <Edit className="w-4 h-4" />
//             </Button>
//           )}
//           {onDelete && (
//             <Button
//               variant="ghost"
//               size="icon"
//               className="w-8 h-8"
//               onClick={(e) => {
//                 e.stopPropagation();
//                 setDeleteDialog(true);
//               }}
//             >
//               <Trash2 className="w-4 h-4 text-red-500" />
//             </Button>
//           )}
//         </div>
//       </div>

//       {/* openModal() */}

//       {/* View Dialog */}
//       <Dialog open={viewDialog} onOpenChange={setViewDialog}>
//         <DialogContent>
//           <DialogHeader>
//             <DialogTitle>{name || "View Details"}</DialogTitle>
//             <DialogDescription>
//               View details for category "{node.name}"
//             </DialogDescription>
//           </DialogHeader>
//           {/* Your custom view component will be rendered here */}
//           {onView && onView(node)}
//         </DialogContent>
//       </Dialog>

//       {/* Delete Confirmation Dialog */}
//       <Dialog open={deleteDialog} onOpenChange={setDeleteDialog}>
//         <DialogContent>
//           <DialogHeader>
//             <DialogTitle>Confirm Delete</DialogTitle>
//             <DialogDescription>
//               This action cannot be undone. This will permanently delete the
//               category "{node.name}" and remove it from our servers.
//             </DialogDescription>
//           </DialogHeader>
//           <p>Are you sure you want to delete "{node.name}"?</p>
//           <DialogFooter>
//             <Button variant="gold" onClick={() => setDeleteDialog(false)}>
//               Cancel
//             </Button>
//             <Button
//               variant="dark"
//               onClick={handleDelete}
//               disabled={deleteMutation.isPending}
//             >
//               {deleteMutation.isPending ? "Deleting..." : "Delete"}
//             </Button>
//           </DialogFooter>
//         </DialogContent>
//       </Dialog>
//     </>
//   );
// }

// --- TreeItem.jsx ---

"use client";

import { Button } from "@/components/ui/button";
import { useModal } from "@/context/ModalProvider";
import {
  ChevronDown,
  ChevronRight,
  Edit,
  Plus,
  Trash2,
  Eye,
} from "lucide-react";
import { useState } from "react";
import { useMutation, useQueryClient } from "@tanstack/react-query";
import Image from "next/image";

export function TreeItem({
  tags,
  node,
  isExpanded,
  onToggle,
  onAdd,
  onEdit,
  onDelete,
  showCount = false,
  AddFormComponent,
  ViewComponent,
}) {
  const { openModal, closeModal } = useModal();
  const queryClient = useQueryClient();
  const [deleteDialogOpen, setDeleteDialogOpen] = useState(false);

  const deleteMutation = useMutation({
    mutationFn: onDelete,
    onSuccess: () => {
      queryClient.invalidateQueries([tags]);
      setDeleteDialogOpen(false);
    },
  });

  const handleDelete = () => {
    deleteMutation.mutate(node.id);
  };

  return (
    <>
      <div
        className="flex items-center justify-between px-4 py-2 hover:bg-gray-100 cursor-pointer"
        onClick={(e) => {
          e.stopPropagation();
          onToggle();
        }}
      >
        <div className="flex items-center">
          <Button variant="ghost" size="icon" className="w-8 h-8">
            {isExpanded ? (
              <ChevronDown className="w-4 h-4 text-gray-500" />
            ) : (
              <ChevronRight className="w-4 h-4 text-gray-500" />
            )}
          </Button>

          {!node?.category_image ? (
            <div className="w-6 h-6 rounded-full bg-brand-dark text-brand-gold flex items-center justify-center text-sm font-bold mr-2 shrink-0">
              {node?.name.slice(0, 1)}
            </div>
          ) : (
            <div className="w-6 h-6 rounded-full overflow-hidden mr-2 shrink-0">
              <Image
                src={node.category_image?.replace("/api", "")}
                alt={node.name}
                width={24}
                height={24}
                className="object-cover w-full h-full"
              />
            </div>
          )}

          <span className="text-sm mr-2">{node.name}</span>
          {showCount && node?.children?.length > 0 && (
            <p className="text-brand-dark text-[9px] bg-gray-100 rounded-full px-1">
              {node?.children?.length}
            </p>
          )}
        </div>

        <div className="flex items-center space-x-2">
          {ViewComponent && (
            <Button
              variant="ghost"
              size="icon"
              className="w-8 h-8"
              onClick={(e) => {
                e.stopPropagation();
                openModal(<ViewComponent node={node} />);
              }}
            >
              <Eye className="w-4 h-4 text-blue-500" />
            </Button>
          )}
          <Button
            variant="ghost"
            size="icon"
            className="w-8 h-8"
            onClick={(e) => {
              e.stopPropagation();
              openModal(
                <AddFormComponent parent_id={node.id} onClose={closeModal} />
              );
            }}
          >
            <Plus className="w-4 h-4" />
          </Button>
          <Button
            variant="ghost"
            size="icon"
            className="w-8 h-8"
            onClick={(e) => {
              e.stopPropagation();
              openModal(
                <AddFormComponent
                  editData={node}
                  type="edit"
                  onClose={closeModal}
                />
              );
            }}
          >
            <Edit className="w-4 h-4" />
          </Button>
          <Button
            variant="ghost"
            size="icon"
            className="w-8 h-8"
            onClick={(e) => {
              e.stopPropagation();
              setDeleteDialogOpen(true);
            }}
          >
            <Trash2 className="w-4 h-4 text-red-500" />
          </Button>
        </div>
      </div>

      {deleteDialogOpen && (
        <div className="fixed inset-0 bg-black/30 z-50 flex items-center justify-center">
          <div className="bg-white rounded shadow-md p-6 w-full max-w-sm">
            <h3 className="text-lg font-semibold mb-2">Confirm Delete</h3>
            <p className="text-sm mb-4">
              Are you sure you want to delete <strong>{node.name}</strong>?
            </p>
            <div className="flex justify-end gap-3">
              <Button
                variant="ghost"
                onClick={() => setDeleteDialogOpen(false)}
              >
                Cancel
              </Button>
              <Button
                variant="dark"
                onClick={handleDelete}
                disabled={deleteMutation.isPending}
              >
                {deleteMutation.isPending ? "Deleting..." : "Delete"}
              </Button>
            </div>
          </div>
        </div>
      )}
    </>
  );
}
