"use client";

import { useEffect, useRef, useState } from "react";
import Image from "next/image";
import Link from "next/link";
import {
  Carousel,
  CarouselContent,
  CarouselItem,
  CarouselNext,
  CarouselPrevious,
} from "@/components/ui/carousel";
import Autoplay from "embla-carousel-autoplay";

const ScrollBottom = ({ data }) => {
  const [hoveredProduct, setHoveredProduct] = useState(null);
  const plugin = useRef(Autoplay({ delay: 3000, stopOnInteraction: false }));

  const activeProducts = data?.items?.filter((data) => data.status === 1);
  useEffect(() => {
    if (activeProducts?.length) {
      plugin.current = Autoplay({ delay: 3000, stopOnInteraction: true });
    }
  }, [activeProducts]);

  const handleMouseEnter = (id) => {
    setHoveredProduct(id);
  };

  const handleMouseLeave = () => {
    setHoveredProduct(null);
  };

  const getProductImages = (productImageStr) => {
    if (!productImageStr) return [];
    return productImageStr.split(",").map((img) => img.trim());
  };

  const getCurrentImage = (product) => {
    const images = getProductImages(product.product_image);
    if (hoveredProduct === product.id && images.length > 1) {
      return images[1];
    }
    return images[0];
  };

  return (
    <section className="w-full py-8 px-4 my-10">
      <div className="max-w-[1600px] mx-auto">
      <h2 className="text-3xl font-cormorant text-center mb-8 uppercase">
        {data?.name}
      </h2>

      {/* Wrap the Carousel in a relative div with group for hover effects */}
      <div className="relative group">
        <Carousel
          plugins={[plugin.current]}
          // plugins={plugin.current ? [plugin.current] : []}
          onMouseEnter={plugin.current.stop}
          onMouseLeave={plugin.current.reset}
          opts={{
            align: "start",
            loop: true,
            slidesToScroll: 1,
          }}
          className="w-full"
        >
          <CarouselContent>
            {activeProducts?.map((product) => (
              <CarouselItem
                key={product.id}
                // className="sm:basis-1/2 md:basis-1/3 lg:basis-1/4"
                className="basis-1/2 md:basis-1/3 lg:basis-1/4"
                // className="basis-1/2 sm:basis-1/3 md:basis-1/4 lg:basis-1/5"
              >
                <Link href={`/${product.product_url}`} className="block">
                  <div
                    className="h-full p-2"
                    onMouseEnter={() => handleMouseEnter(product.id)}
                    onMouseLeave={handleMouseLeave}
                  >
                    <div className="relative">
                      <div className="relative w-full pt-[100%]">
                        <Image
                          src={getCurrentImage(product)?.replace("/api", "")}
                          alt={product.name}
                          fill
                          className="object-cover transition-opacity duration-300"
                          sizes="(max-width: 640px) 100vw, (max-width: 768px) 50vw, (max-width: 1024px) 33vw, 25vw"
                        />
                        {/* {product.status === 1 && (
                          <div className="absolute top-2 right-2 bg-red-600 text-white text-xs px-2 py-1">
                            Hot
                          </div>
                        )} */}
                      </div>
                    </div>
                    <div className="flex flex-col items-center p-4">
                      <div className="text-center font-medium text-sm uppercase tracking-wider hover:text-brand-dark transition-colors">
                        {product.name}
                      </div>
                    </div>
                  </div>
                </Link>
              </CarouselItem>
            ))}
          </CarouselContent>
          {/* Previous and Next buttons: show on group hover */}
          {activeProducts?.length > 1 && (
            <>
              <CarouselPrevious className="absolute left-0 top-1/2 -translate-y-1/2 bg-brand-dark text-white hover:text-white p-2 rounded-full opacity-0 transition-opacity duration-300 group-hover:opacity-100" />
              <CarouselNext className="absolute right-0 top-1/2 -translate-y-1/2 bg-brand-dark text-white hover:text-white p-2 rounded-full opacity-0 transition-opacity duration-300 group-hover:opacity-100" />
            </>
          )}

          {/* <CarouselPrevious className="absolute left-0 top-1/2 -translate-y-1/2 bg-brand-dark text-white hover:text-white p-2 rounded-full opacity-0 transition-opacity duration-300 group-hover:opacity-100" /> */}
          {/* <CarouselNext className="absolute right-0 top-1/2 -translate-y-1/2 bg-brand-dark text-white hover:text-white p-2 rounded-full opacity-0 transition-opacity duration-300 group-hover:opacity-100" /> */}
        </Carousel>
      </div>
      </div>
    </section>
  );
};

export default ScrollBottom;
