"use client";

import {
  Carousel,
  CarouselContent,
  CarouselItem,
  CarouselDots,
} from "@/components/ui/carousel";
import { useRef } from "react";
import Autoplay from "embla-carousel-autoplay";
import Link from "next/link";
import { useBanners } from "@/hooks/useData";
import { cn } from "@/lib/utils";

export default function Hero() {
  const plugin = useRef(Autoplay({ delay: 5000, stopOnInteraction: false }));
  const { data } = useBanners();
  const slides = data?.rows || [];

  return (
    <section className="relative w-full h-[85vh] md:h-screen overflow-hidden bg-[#05101A]">
      <Carousel
        plugins={[plugin.current]}
        onMouseEnter={plugin.current.stop}
        onMouseLeave={plugin.current.reset}
        className="w-full h-full"
        opts={{ loop: true, duration: 40 }}
      >
        <CarouselContent className="-ml-0">
          {slides.map((slide, index) => {
            const {
              title,
              image,
              description,
              button_link,
              visibility,
              alignment,
            } = slide;

            // 1. Determine Alignment State
            const isLeft = +alignment === 1;
            const isRight = +alignment === 2;
            const isCenter = !isLeft && !isRight;

            // 2. Container Alignment (Flexbox)
            const containerAlign = isLeft
              ? "items-start pl-6 md:pl-24"
              : isRight
                ? "items-end pr-6 md:pr-24"
                : "items-center px-6";

            // 3. Text Alignment (Typography)
            const textAlign = isLeft
              ? "text-left"
              : isRight
                ? "text-right"
                : "text-center";

            return (
              <CarouselItem
                key={index}
                className="pl-0 relative h-[85vh] md:h-screen w-full"
              >
                {/* Background Image */}
                <div
                  className="absolute inset-0 bg-cover bg-center transition-transform duration-700"
                  style={{
                    backgroundImage: `url(${image?.replace("/api", "")})`,
                  }}
                />

                {/* Dark Gradient Overlay */}
                <div
                  className={cn(
                    "absolute inset-0 bg-gradient-to-r",
                    isLeft
                      ? "from-[#020f1d]/90 via-[#020f1d]/40 to-transparent"
                      : isRight
                        ? "from-transparent via-[#020f1d]/40 to-[#020f1d]/90"
                        : "from-[#020f1d]/60 via-transparent to-[#020f1d]/60 bg-black/20",
                  )}
                />

                {/* Content Container */}
                <div
                  className={`relative z-20 flex flex-col justify-center h-full w-full max-w-7xl mx-auto ${containerAlign}`}
                >
                  {visibility?.show_content == "1" && (
                    <div
                      className={cn(
                        "max-w-2xl space-y-4 md:space-y-6 animate-in fade-in slide-in-from-bottom-6 duration-1000",
                        textAlign,
                        isRight ? "items-end flex flex-col" : "",
                        isLeft ? "items-start flex flex-col" : "",
                      )}
                    >
                      {/* Title */}
                      <h1 className="font-cormorant text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-medium tracking-tight text-white leading-[1.1]">
                        <span className="block text-transparent bg-clip-text bg-gradient-to-r from-yellow-200 via-yellow-50 to-yellow-200">
                          {title}
                        </span>
                      </h1>

                      {/* Description */}
                      {visibility?.show_description == "1" && description && (
                        <p
                          className={cn(
                            "text-sm sm:text-base md:text-lg text-gray-200 font-light tracking-wide leading-relaxed max-w-lg",
                            textAlign,
                            isCenter && "mx-auto",
                            isRight && "ml-auto",
                            isLeft && "mr-auto",
                          )}
                        >
                          {description}
                        </p>
                      )}

                      {/* Button - UPDATED for better mobile sizing */}
                      {visibility?.show_button == "1" && button_link && (
                        <div
                          className={cn(
                            "pt-4",
                            isRight && "ml-auto",
                            isCenter && "mx-auto",
                          )}
                        >
                          <Link
                            href={`/${button_link}`}
                            className="group relative inline-flex items-center gap-2 md:gap-3 px-6 py-2 md:px-8 md:py-3 overflow-hidden border border-yellow-600/50 hover:border-brand-gold text-white transition-all duration-300"
                          >
                            <span className="absolute inset-0 bg-yellow-600/10 translate-y-full group-hover:translate-y-0 transition-transform duration-300 ease-out" />
                            <span className="relative font-lato text-[10px] md:text-sm uppercase tracking-[0.2em] font-medium text-yellow-50 group-hover:text-white">
                              Explore Now
                            </span>
                            <span className="relative text-brand-gold group-hover:translate-x-1 transition-transform duration-300 text-xs md:text-base">
                              →
                            </span>
                          </Link>
                        </div>
                      )}
                    </div>
                  )}
                </div>
              </CarouselItem>
            );
          })}
        </CarouselContent>

        {/* Navigation Dots */}
        <div className="absolute bottom-10 left-1/2 -translate-x-1/2 z-30">
          <CarouselDots
            activeColor="bg-brand-gold"
            inactiveColor="bg-white/20"
            className="gap-4"
          />
        </div>
      </Carousel>
    </section>
  );
}
