"use client";

import Image from "next/image";
import Link from "next/link";
import { ArrowRight } from "lucide-react";

export default function ComboBox({ data }) {
  if (!data?.length) return null;

  return (
    <section className="py-12 px-4 md:px-8 bg-white">
      <div className="max-w-[1600px] mx-auto grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-8">
        {data.map((item, i) => {
          const img = item.image?.replace("/api", "");

          return (
            <Link
              key={item.id}
              href={`/${item.url}`}
              className="group relative block w-full overflow-hidden"
            >
              {/* Card Container - Cinematic Aspect Ratio */}
              <div className="relative w-full aspect-[3/2] md:aspect-[16/10] overflow-hidden bg-stone-100">
                {/* 1. Image - Slow Scale & Pan */}
                <Image
                  src={img}
                  alt={item.name}
                  fill
                  className="object-cover transition-transform duration-[1.5s] ease-in-out group-hover:scale-110"
                  sizes="(max-width: 768px) 100vw, 50vw"
                />

                {/* 2. Overlay - Darkens on hover for text readability */}
                <div className="absolute inset-0 bg-black/20 transition-colors duration-500 group-hover:bg-black/40" />

                {/* 3. Decorative Border - The "Frame" Effect */}
                {/* This is a thin white line that sits 12px inside the image */}
                <div className="absolute inset-3 border border-white/30 opacity-70 transition-all duration-500 group-hover:inset-4 group-hover:border-white/80 group-hover:opacity-100" />

                {/* 4. Content - Centered */}
                <div className="absolute inset-0 flex flex-col items-center justify-center p-6 text-center z-10">
                  {/* Title */}
                  <h3 className="text-3xl md:text-4xl lg:text-5xl font-cormorant text-white font-medium tracking-wide shadow-sm transform transition-transform duration-500 group-hover:-translate-y-2">
                    {item.name}
                  </h3>

                  {/* Divider */}
                  <div className="w-0 group-hover:w-16 h-[1px] bg-brand-gold my-4 transition-all duration-500 ease-out" />

                  {/* "Explore" Button - Fades in */}
                  <div className="flex items-center gap-2 opacity-0 transform translate-y-4 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-500 delay-100">
                    <span className="text-sm font-lato text-white/90 uppercase tracking-[0.2em]">
                      Explore Collection
                    </span>
                    <ArrowRight className="w-4 h-4 text-brand-gold" />
                  </div>
                </div>
              </div>
            </Link>
          );
        })}
      </div>
    </section>
  );
}
