import "./globals.css";
import { geistSans, geistMono, cormorant, lato } from "./font";
import QueryContainer from "@/context/QueryContainer";
import { SettingsProvider } from "@/context/SettingsContext";
import { Toaster } from "react-hot-toast";
import Providers from "@/context/provider";
import { ModalProvider } from "@/context/ModalProvider";
import AppInitializer from "@/components/Layout/AppInitializer";
import "./globals.js";

export default function RootLayout({ children }) {
  return (
    <html lang="en">
      <body
        className={`${geistSans.variable} ${geistMono.variable} ${cormorant.variable} ${lato.variable} antialiased`}
      >
        <QueryContainer>
          <SettingsProvider>
            {/* <Providers>{children}</Providers> */}
            <ModalProvider>
              <AppInitializer>{children}</AppInitializer>
            </ModalProvider>
          </SettingsProvider>
        </QueryContainer>
        <Toaster position="top-right" />
      </body>
    </html>
  );
}
