if (!globalThis.globalJsonParse) {
  Object.defineProperty(globalThis, "globalJsonParse", {
    value: function (val) {
      if (
        val === null ||
        val === "null" ||
        val === "undefined" ||
        val === undefined
      )
        return null;
      if (typeof val === "object") return val;

      if (typeof val === "string") {
        try {
          return JSON.parse(val);
        } catch {
          return val;
        }
      }

      return val;
    },
    writable: false,
    configurable: false,
  });
}
