import Providers from "@/context/provider";
import { getSettings } from "@/lib/getSettings";
export const generateMetadata = async () => {
  const [rows] = await getSettings();
  const settings = rows.reduce((acc, curr) => {
    acc[curr.settings_name] = curr.settings_value;
    return acc;
  }, {});

  return {
    title: settings?.name || "Selvakumar Jewellary",
    icons: {
      icon: [
        {
          url: settings?.icon?.replace("/api", "") || "/images/logo-dark.png",
          type: settings?.icon?.endsWith(".webp") ? "image/webp" : "image/png",
        },
      ],
    },
  };
};

export default function Layout({ children }) {
  return <Providers>{children}</Providers>;
}
