"use client";

import React from "react";
import { ChevronRight } from "lucide-react";
import { usePathname } from "next/navigation";
import Link from "next/link";

import Image from "next/image";

export default function ProductsPageTop({ name, backgroundImage }) {
  const pathname = usePathname();

  const breadcrumbs = pathname
    .split("/")
    .filter((segment) => segment !== "")
    .map((segment, index, array) => ({
      label: (segment.charAt(0).toUpperCase() + segment.slice(1)).replaceAll(
        "-",
        " "
      ),
      href: "/" + array.slice(0, index + 1).join("/"),
    }));

  const img = backgroundImage
    ? backgroundImage
    : pathname.includes("gold")
      ? "/images/gold.jpg"
      : "/images/silver.jpg";

  return (
    <div className="w-full ">
      <div className="relative h-80 md:h-96 lg:h-[26rem] ">
        {/* Background image */}
        <Image
          src={img?.replace("/api", "")}
          alt="background"
          fill
          // loading="lazy"
          sizes="(max-width: 768px) 100vw,100vw"
          priority
          className="w-full h-full object-cover object-center absolute inset-0"
        />

        {/* Overlay */}
        <div className="absolute inset-0 bg-gradient-to-r from-black/50 to-transparent"></div>

        {/* Centered content */}
        <div className="absolute inset-0 flex flex-col items-start justify-end z-10 px-4 ">
          <div className=" px-6 py-2 rounded-md mb-5">
            <h1 className=" text-2xl sm:text-2xl md:text-4xl  text-white font-cormorant font-bold">
              {name || "Products"}
            </h1>

            {/* Dynamic Breadcrumbs */}
            <div className="flex items-center mt-2 text-white">
              <Link
                href="/"
                className=" text-sm sm:text-base hover:underline font-lato"
              >
                Home
              </Link>
              {breadcrumbs.map((breadcrumb, index) => (
                <React.Fragment key={index}>
                  <span className="mx-1">
                    <ChevronRight className="h-4 w-4 inline" />
                  </span>
                  <Link
                    href={breadcrumb.href}
                    className={`text-sm sm:text-base font-lato ${index === breadcrumbs.length - 1 ? "font-bold" : "hover:underline"}`}
                  >
                    {breadcrumb.label}
                  </Link>
                </React.Fragment>
              ))}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
