"use client";

import {
  getCategories,
  deleteCategory,
} from "@/Services/Categories/ApiCategory";
import { useQuery } from "@tanstack/react-query";
import { Card, CardHeader, CardTitle, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Plus } from "lucide-react";
import { TreeView } from "@/components/ui/Tree/TreeView";
import { TreeItem } from "@/components/ui/Tree/TreeItem";

import { DataTable } from "@/components/ui/DataTableNew";
import { useModal } from "@/context/ModalProvider";
import Image from "next/image";
import AddCategoryForm from "./AddCategory";

export default function CategoryManagement() {
  const { openModal, closeModal } = useModal();

  const { data: categories = [] } = useQuery({
    queryKey: ["categories"],
    queryFn: getCategories,
  });

  // const handleAddClick = (parent_id = null) => {
  //   openModal(<AddCategoryForm parent_id={parent_id} onClose={closeModal} />);
  // };

  const handleClick = (url) => {
    openModal(
      <div className="w-full h-full flex justify-center items-center">
        <Image
          src={url?.replace("/api", "")}
          alt="Testimonial"
          width={600}
          height={600}
          className="max-h-fit object-contain"
          loading="lazy"
        />
      </div>
    );
  };

  const columns = [
    {
      accessorKey: "category_name",
      header: "Name",
      cell: (info) => info.getValue(),
    },
    {
      header: "Image",
      cell: (info) =>
        info.row.original.category_image ? (
          <Button
            variant="ghost"
            className="h-8 w-8 p-0"
            onClick={() => handleClick(info.row.original.category_image)}
          >
            <span className="sr-only">Open menu</span>
            <Image
              src={info.row.original.category_image?.replace("/api", "")}
              alt="testimonial"
              width={50}
              height={50}
              className="rounded"
              loading="lazy"
            />
          </Button>
        ) : (
          "No Image"
        ),
    },

    {
      accessorKey: "category_status",
      header: "Status",
      cell: (info) => (info.getValue() == 1 ? "Active" : "Inactive"),
    },
  ];

  return (
    <div>
      <Card className="w-full  mx-auto pt-0 rounded-md">
        <CardHeader className="flex flex-row justify-between items-center bg-brand-dark text-brand-gold rounded-t-md py-3">
          <CardTitle>Category Management</CardTitle>
          <Button
            variant="gold"
            // onClick={() => handleAddClick()}
            onClick={() =>
              openModal(
                <AddCategoryForm parent_id={null} onClose={closeModal} />
              )
            }
            className="flex items-center"
          >
            <Plus className="mr-2 w-4 h-4" />
            Add
          </Button>
        </CardHeader>
        <CardContent className="p-0">
          <div className="divide-y divide-gray-200">
            <TreeView
              nodes={categories || []}
              renderItem={(props) => (
                // <TreeItem
                //   {...props}
                //   showCount
                //   tags="categories"
                //   onAdd={handleAddClick}
                //   onEdit={handleEditClick}
                //   onDelete={deleteCategory}
                // />
                <TreeItem
                  {...props}
                  showCount
                  tags="categories"
                  AddFormComponent={AddCategoryForm}
                  onDelete={deleteCategory}
                />
              )}
            />
          </div>
        </CardContent>
      </Card>

      <DataTable
        title="Manage Categories"
        fetchData={() => getCategories(0, 10, false, true)}
        columnsConfig={columns}
        tag="categories"
        onDelete={deleteCategory}
        EditComponent={AddCategoryForm}
      />
    </div>
  );
}
