import { del, get, patch, post } from "@/lib/apiService";

const API_URL = "/api/product-collections";

export const addProductCollection = (formData) => {
  return post(API_URL, formData);
};

export const editProductCollection = (formData) => {
  return patch(API_URL, formData);
};

export const deleteProductCollection = (id) => {
  return del(API_URL, { id });
};

export const getProductCollections = (
  pageIndex = 0,
  pageSize = 10,
  filters = {}
) => {
  const query = new URLSearchParams({
    pageIndex: pageIndex.toString(),
    pageSize: pageSize.toString(),
    filters: JSON.stringify(filters),
  }).toString();

  return get(`${API_URL}?${query}`);
};

export const getAllProductCollections = () => {
  const query = new URLSearchParams({
    all: true,
  }).toString();

  return get(`${process.env.NEXT_PUBLIC_BASE_URL}${API_URL}?${query}`);
};

export async function getCollectionBySlug(slug) {
  return get(`${process.env.NEXT_PUBLIC_BASE_URL}${API_URL}/${slug}`);
}
