import { del, get, patch, post } from "@/lib/apiService";

const API_URL = "/api/branches";

export const addBranch = (data) => {
  return post(API_URL, data);
};

export const editBranch = (data) => {
  return patch(API_URL, data);
};

export const deleteBranch = (id) => {
  return del(API_URL, { id });
};

export const getBranches = (activeOnly = false) => {
  const url = activeOnly ? `${API_URL}?activeOnly=true` : API_URL;
  return get(url);
};
